# Neck Cut Build Instructions

This distribution provides everything necessary to build and run a Polyscope project with our code within it.

You need the following dependencies:

```sh
apt-get install -y cmake make g++ git libx11-dev libxrandr-dev libxinerama-dev libxcursor-dev libxi-dev libgl-dev
```

Once that is installed, building should be simple:

```sh
mkdir build
cd build
cmake ..
make # Optionally multithread with make -j8
```

The built executable will then be located in `build/bin/iso_dij`.

You can run the executable, with a 3D object file like so (many 3D model file formats are supported):
```sh
./iso_dij ./bunny.obj 25 show
```

You can configure the number of filtered salient points as a third parameter:

```sh
./iso_dij ./bunny.obj 10
```

## Docker Instructions
We provide a dockerfile for reproducibility of a stable environment.

To build the docker:
```sh
docker build -t neckcuts .
```

To run it:
```sh
docker run -it neckcuts
```
The files will be in `/run/neckcuts/`.

If you want to support X11 Forwarding to use it graphically inside the docker, run the following two commands instead:
```sh
xhost +local:docker
docker run -it -v /tmp/.X11-unix:/tmp/.X11-unix neckcuts
```
