// Copyright 2017-2023, Nicholas Sharp and the Polyscope contributors. https://polyscope.run

#pragma once

#include "polyscope/affine_remapper.h"
#include "polyscope/histogram.h"
#include "polyscope/point_cloud.h"
#include "polyscope/render/color_maps.h"
#include "polyscope/scalar_quantity.h"

#include <vector>

namespace polyscope {

class PointCloudScalarQuantity : public PointCloudQuantity, public ScalarQuantity<PointCloudScalarQuantity> {

public:
  PointCloudScalarQuantity(std::string name, const std::vector<float>& values, PointCloud& pointCloud_,
                           DataType dataType);

  virtual void draw() override;
  virtual void buildCustomUI() override;

  virtual void buildPickUI(size_t ind) override;
  virtual void refresh() override;

  virtual std::string niceName() override;

protected:
  void createProgram();

  std::shared_ptr<render::ShaderProgram> pointProgram;
};


} // namespace polyscope
