#pragma once
#include "geometrycentral/surface/manifold_surface_mesh.h"
#include "geometrycentral/surface/meshio.h"
#include "geometrycentral/surface/vertex_position_geometry.h"
#include "polyscope/polyscope.h"
#include "polyscope/surface_mesh.h"

#include <queue>
#include <iostream>

using namespace geometrycentral;
using namespace geometrycentral::surface;

// Float, Obj Pairs
typedef std::pair<float, Vertex> vPair;
typedef std::pair<float, Edge> ePair;

// SSSP pair
typedef std::pair<VertexData<Halfedge>, VertexData<float>> sssp_t;

// Event Queue
typedef std::priority_queue<ePair, std::vector<ePair>, std::greater<ePair>> eventQueue;

class NeckModel{
    public:
        // Constructors
        NeckModel() = default;
        NeckModel(std::string filename);
        // ~NeckModel();

        // Function Defs

        // Compute the shortest path from s to all other vertices and store in _dists, _prev
        void compute_shortest_paths(Vertex s);
        
        //SSSP Algorithms
        sssp_t st_dijkstras(Vertex s, Vertex t);
        sssp_t sssp(Vertex s);
        std::pair<sssp_t, vPair> sssp_report_furthest(Vertex s);
        std::pair<sssp_t,Vertex> stgroup_dijkstras(Vertex s, std::unordered_set<Vertex> ts);


        // std::vector<Halfedge> find_he_path(sssp_t sssp);
        std::vector<Halfedge> get_he_path(sssp_t sssp, Vertex s, Vertex t);
        std::vector<std::vector<Halfedge>> get_cycles_from_path(std::vector<Halfedge> he_path);
        std::vector<std::vector<std::vector<Halfedge>>> get_cycles_from_skeleton(std::vector<std::vector<Halfedge>> skeleton);

        // Helpers
        Edge get_edge(Vertex v1, Vertex v2);

        // Vars

        // Mesh Variables
        std::unique_ptr<ManifoldSurfaceMesh> mesh; // The mesh data structure
        std::unique_ptr<VertexPositionGeometry> geometry; // The geometry data structure
        float sum_mesh_dist = 0; // Sum of all mesh edge lengths

        // Wavefront Init Variables
        Vertex _source; // Source vertex to run wavefront from
        Vertex _anti_source;

        // Shortest Path Props
        VertexData<float> _dists; //Vertex Dict of shortest path dists from _source
        VertexData<Vertex> _prev; //Vertex Dict of previous vertex in shortest path from _source

        std::vector<std::set<Edge>> good_cycles;

        std::vector<std::vector<Halfedge>> salient_cycles_output;
        std::vector<std::vector<std::vector<Halfedge>>> skeleton_cycles_output;

};



// Random Utils
inline void qprint(std::string printstr){
    std::cout << printstr << std::endl;
}

